import glob, os
import json
import jsonschema
from jsonschema import validate


#
# By: John Corley
# Date: 28th Nov 2019
# Notes: 
# Simple program that loads the schema file called iswc_publisher_schema_2.json from the 
# current directory and then validates that all *.json files in that directory conform
# to the schema (excluding the iswc_publisher_schema_2.json file itself)
#

schema = json.loads(open('iswc_schema_v2.json', 'rb').read().decode('utf-8'))

os.chdir(".")

for fileName in glob.glob("*.json"):
    if fileName != "iswc_schema_v2.json":
        data = json.loads(open(fileName,'rb').read().decode('utf-8'))
    
        print("Validate file using the schema:", fileName)
        try:
            validate(data, schema)
            print("File matches schema :)\n")
        except jsonschema.exceptions.ValidationError as ve:
            print("File does not match schema :( .... details to follow\n")
            print(str(ve) + "\n")

